<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;
    protected $fillable = array('user_name', 'name', 'email', 'phone', 'gender', 'd_o_b', 'activation', 'accept_privacy', 'mute_notification', 'last_login');

    public function contacts()
    {
        return $this->morphMany('App\Models\Contact', 'contactable');
    }

    public function credit_cards()
    {
        return $this->morphMany('App\Models\CreditCard', 'cardable');
    }

    public function clientReviews()
    {
        return $this->hasMany('App\Models\ClientReview');
    }

    public function serviceProviderReviews()
    {
        return $this->hasMany('App\Models\Review');
    }

}